#Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of 
# this software and associated documentation files (the "Software"), to deal in 
# the Software without restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
# the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#作成　2022.6.15
#WFの動作を確認するプログラム visaで動くようにした。

import pyvisa as visa   #PyVISAをimportする。
from time import sleep   #sleepをimportする

rm=visa.ResourceManager() #インスタンス生成
visa_list=rm.list_resources()#PCに接続されている機器のVISAリソース名取得
#print("VISA: "+visa_list)
usb_1=visa_list[0] #複数機器が接続されている場合[]内の数字で指定。

print("VISA: "+usb_1)

inst_1=rm.open_resource(usb_1)

inst_1.write_termination='\n'
inst_1.read_termination='\n'

inst_1.write('*IDN?')
sleep(0.1)
out=inst_1.read()
#out=inst_1.query("*IDN?",delay=1)

print("IDN: "+out)
print()

#inst_1.write("*RST")   #WF1973をリセットする。
inst_1.write(':FUNC SIN')   #波形を設定する
inst_1.write(':FREQ '+input('Freq [Hz] = ? '))   #周波数を設定する。
inst_1.write(':VOLT '+input('Volt[Vp-p] = ?'))   #振幅を設定する。
inst_1.write(':VOLT:OFFS '+input('offset [V] = ?'))   #オフセットを設定する。

print('OUTPUT ON')
inst_1.write(':OUTP ON')   #出力をONする。

print("終了")
