# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# 作成　2022.7.28
# WF1974とDM2571が同時に動作できるか確認するプログラム
# WF1974で指定の波形を出力したあと、DM2571で振幅、オフセット、周波数を測る。

from time import sleep  # sleepをimportする

import pyvisa  # pyvisaのインポート

rm = pyvisa.ResourceManager()  # インスタンスを生成

# 下記の行のserial No.をご使用の機器の番号に変更してください。
inst_1 = rm.open_resource("USB::0x0D4A::0x000E::0000000::INSTR")  # WF1974に接続する。
#                                                ↑
#                                             serial No
inst_2 = rm.open_resource("USB::0x0D4A::0x0065::GET8304::INSTR")  # DM2571に接続する
#                                                ↑
#                                             serial No

inst_1.write("*RST")  # WF1974をリセットする。
r_txt = inst_1.query("*IDN?")  # WF1974の機器確認をする。
print(r_txt)  # 返信を表示する。

inst_2.write("*RST")  # DM2571をリセットする。
sleep(1)
r_txt = inst_2.query("*IDN?")  # DM2571の機器確認をする。
print(r_txt)  # 返信を表示する。

inst_1.write(':FUNC SIN')  # 波形を設定する
inst_1.write(':FREQ '+input("freq=?"))  # 周波数を設定する。
inst_1.write(':VOLT '+input("AC Volt=?"))  # 振幅を設定する。
inst_1.write(':VOLT:OFFS '+input("offset=?"))  # オフセットを設定する。

inst_1.write(':OUTP ON')  # 出力をONする。
sleep(5)  # 5sec待つ


print('\n')  # 改行
print('振幅[Vrms]')  # 振幅[Vrms]と表示
inst_2.write('conf:ac')  # 測定モードをAC電圧に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。
print('\n')  # 改行
print('オフセット[V]')  # オフセット[V]と表示
inst_2.write('conf:dc')  # 測定モードをDC電圧に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。
print('\n')  # 改行
print('周波数[Hz]')  # 周波数[Hz]と表示
inst_2.write('conf:FREQ')  # 測定モードを周波数に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。


print("終了")
