# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# 　LI5650/LI5645/LI5655/LI5660のサンプルプログラム

#  2022.7.28
# 　LI5650/LI5645 取扱説明書（リモート制御）p115 例2_BUF3 を参考に作成
#  外部発振器を使う。

# 　モジュールのインポート
import pyvisa  # pyvisaモジュールをインポート
from time import sleep  # sleepをインポート

# LIに接続
rm = pyvisa.ResourceManager()  # インスタンス生成
visa_list = rm.list_resources()  # PCに接続されている機器のVISAリソース名取得

print(visa_list)

usb_1 = visa_list[1]  # 複数機器が接続されている場合[]内の数字で指定。
msg = rm.open_resource(usb_1)  # 接続
print(msg.query('*IDN?'))
print(usb_1)

# 初期化設定
msg.write("*RST")  # リセットする。
sleep(1)

msg.write(":DATA:FEED BUF3,6")  # 記録する測定データセットを設定する。DATA1,DATA2 の値を記録する。
msg.write(":DATA:POIN BUF3,100")  # 測定データバッファ3 のサイズを100（サンプル点）に設定
msg.write(":DATA:FEED:CONT BUF3,ALW")  # 測定データバッファをBUF3に指定して測定データを記録することを有効にする。
IN_TIMER = 1E-3  # 内部タイマの時間間隔を1E-3（1ms）にする。
msg.write(":DATA:TIM "+str(IN_TIMER))  # 内部タイマの時間間隔を設定する。
msg.write(":DATA:TIM:STAT ON")  # 内部タイマを有効にする。

msg.write(":AUTO:ONCE")  # 感度や時定数を一度だけ自動設定する。
sleep(2)  # :AUTO:ONCEが終わるだろう時間を待つ
msg.write(":FILT:TCON 1")  # 時定数を設定する。
sleep(1)  # :AUTO:ONCEが終わるだろう時間を待つ

TRIG_S = "BUS"  # トリガ源をBUSとする。
msg.write(":TRIG:SOUR "+TRIG_S)  # トリガ源をリモート制御（BUS）に設定する。

msg.write(":INIT")  # トリガ待ちに移行する。当時間間隔で測定データの記録を開始する。
msg.write(":TRIG")  # トリガ信号を送る

sleep(0.1)  # トリガ後安定するまで待つ

msg.write(":FORM ASC")  # データ転送形式をASCIIに設定する。
msg.write(":DATA:DATA? BUF3,1")  # 測定データバッファ(BUF3)からサンプル点数2個のデータ転送を要求する。
rcv_data = msg.read()  # データを読み出す。
print(rcv_data)  # データを表示する。

msg.write(":DATA:FEED:CONT BUF3,NEV")  # バッファの記録を停止する。
