# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of 
# this software and associated documentation files (the "Software"), to deal in 
# the Software without restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
# the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#　LI5650/LI5645/LI5655/LI5660のサンプルプログラム

#  2023.1.26
#　LI5650/LI5645 取扱説明書（リモート制御）p115 例2_BUF3 を参考に作成
#  外部発振器を使う。

#　モジュールのインポート
import pyvisa  #pyvisaモジュールをインポート
from time import sleep #sleepをインポート

#LIとWFに接続
rm = pyvisa.ResourceManager()  #インスタンス生成
visa_list = rm.list_resources()    #PCに接続されている機器のVISAリソース名取得
msg1 = rm.open_resource("USB::0x0D4A::0x0049::0000003::INSTR")    #接続
msg2 = rm.open_resource("USB::0x0D4A::0x000E::0000000::INSTR")    #接続
print(msg1.query("*IDN?"))
print(msg2.query("*IDN?"))

#初期化設定
msg1.write ("*RST")        #リセットする。
msg2.write ("*RST")        #リセットする。
sleep(1)

#WF
msg2.write(':FUNC SIN')   #波形を設定する
L_freq=float(input("LOW freq[Hz]=?"))   #最低周波数を設定する。
h_freq=float(input("HIGH freq[Hz]=?"))   #最高周波数を設定する。
step_freq=float(input("STEP freq[Hz]=?"))  #ステップ周波数を設定する
interval=float(input("interval time[sec]=?  (>=1[sec])"))  #インターバル時間を設定する
wf_out=float(input("AC Volt[Vrms]=?"))   #発振器振幅を入力する。
msg2.write(':VOLT '+str(wf_out)+"Vrms")   #発振器振幅を設定する。
msg2.write(':VOLT:OFFS '+input("offset[V]=?"))   #オフセットを設定する。
TC=input("TC[s]=?")   #時定数を入力する。
sens=input("sens[V]=?")   #感度を入力する。

msg2.write(':OUTP ON')   #発振器出力をONする。


# LI
msg1.write (":DATA:FEED BUF3,6")    #記録する測定データセットを設定する。DATA1,DATA2 の値を記録する。
msg1.write (":DATA:POIN BUF3,100")    #測定データバッファ3 のサイズを100（サンプル点）に設定
msg1.write (":DATA:FEED:CONT BUF3,ALW")    #測定データバッファをBUF3に指定して測定データを記録することを有効にする。

msg1.write (":DATA:TIM "+str(0.001))    #内部タイマの時間間隔を設定する。
msg1.write (":DATA:TIM:STAT ON")    #内部タイマを有効にする。
msg1.write (":VOLT:AC:RANG "+sens)    #感度を設定する。
msg1.write (":FILT:TCON "+TC)    #時定数を設定する。

TRIG_S="BUS"                       #トリガ源をBUSとする。
msg1.write (":TRIG:SOUR "+TRIG_S)    #トリガ源をリモート制御（BUS）に設定する。

msg1.write (":FORM ASC")    #データ転送形式をASCIIに設定する。

r=open("LI5660-WF1974-sweep.txt","w")    #出力ファイルのオープン

print('\n')   #改行
print('周波数[Hz]　振幅[Vrms]  位相[deg]')   #振幅[Vrms]と表示
r.write('周波数[Hz]　振幅[Vrms]  位相[deg]'+"\n")        #ファイルにラベルを書き込む

freq=L_freq        #測定周波数に最低周波数を設定する。
i=0
while freq<h_freq+step_freq :        #測定周波数が細孔周波数になるまでループさせる。
#WF
    msg2.write(":FREQ "+str(freq))        #WFを測定周波数に設定する。
    sleep(interval)      #測定まで待つ
#LI
    msg1.write (':DATA:DEL BUF3')    #BUF3をクリアする。
    msg1.write (":INIT")    #トリガ待ちに移行する。当時間間隔で測定データの記録を開始する。
    msg1.write (":TRIG")    #トリガ信号を送る
    sleep(0.1)      #測定まで待つ
    msg1.write (":DATA:DATA? BUF3,1")    #測定データバッファ(BUF3)からサンプル点数1個のデータ転送を要求する。
    rcv_data=msg1.read()  #データを読み出す。
    print(freq,rcv_data)  #データを表示する。
    r.write(str(freq)+","+rcv_data)        #ファイルに測定データを出力する。
    freq=freq+step_freq        #測定周波数をインクリメントする。
