# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of 
# this software and associated documentation files (the "Software"), to deal in 
# the Software without restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
# the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

# FRA51615のサンプルプログラム

# 2022.07.20 木村
# 当プログラムはFRA51615取扱説明書（外部制御）p89のブロック図を基に作成した。
# スイープデータを測定する。

import pyvisa  #pyvisaのインポート
from time import sleep

rm = pyvisa.ResourceManager()  #インスタンスを生成
visa_list = rm.list_resources()  #PCに接続されている機器のVISAリソース名取得
usb_1 = visa_list[0]  #複数機器が絶属されている場合[]内の数字で指定

print(usb_1)  #接続する測定器のVISAリソースを表示

inst_1 = rm.open_resource(usb_1)  #接続
#inst_1.write("*RST")   #FRA51615をリセットする。
r_txt=inst_1.query("*IDN?")   #FRA51615の機器確認をする。
print(r_txt)   #機器情報を表示する。

#初期化設定
inst_1.write("*RST")   #リセットする。
inst_1.write("*CLS")   #イベントレジスタを初期化する。
#inst_1.write(":STAT:OPER:NTR 2")   #スポット測定完了確認用に設定
inst_1.write(":STATus:OPERation:NTRansition 2")   #スポット測定完了確認用に設定
#OSC設定
inst_1.write(":SOUR:VOLT "+input("振幅を入力してください。[Vpk]"))   #振幅を入力する。最後にVをつけること
inst_1.write(":SOUR:BIAS "+input("オフセットを入力してください。[V]"))   #オフセットを入力する。最後にVをつけること
inst_1.write(":SOUR:FUNC SIN")   #波形を正弦波に指定する。
inst_1.write(":OUTP ON")   #出力をONする。
sleep(1)
r_txt=inst_1.query(":OUTP?")   #出力状態を確認する。
print(r_txt)   #出力状態を表示する。

#Mesure測定
inst_1.write(":SENS:AVER:COUN "+input("積分回数を入力してください。")+",CYCL")   #積分回数を入力する。

#Sweep設定
inst_1.write(":SOUR:FREQ:STAR "+input("sweep下限周波数を入力してください。[Hz]"))   #sweep下限周波数を入力する。
inst_1.write(":SOUR:FREQ:STOP "+input("sweep上限周波数を入力してください。[Hz]"))   #sweep上限周波数を入力する。
inst_1.write(":SOURce:SWEep:POINts "+input("sweep点数を入力してください。"))   #sweep点数を入力する。
inst_1.write(":SOUR:SWE:SPAC "+input("sweep方法を設定します。「LOG」または「LIN」を入力してください。"))

#Graph設定
inst_1.write(":CALC:FORM FREQ,MLOG,PHAS")   #測定結果を周波数、ゲイン、位相の形式で取得するように設定する。

#測定開始
print("スイープ中")
inst_1.write(":TRIG UP")   #スイープ測定を開始

#スイープ測定終了監視
ok=""   #mes変数の初期化
while ok=="":   #mesが""の間ループを回す。
    inst_1.write(":STAT:OPER?")   #測定が完了しているかオペレーションイベントレジスタで確認
    mes=inst_1.read()
    if int(mes) and 2 == 2:   #bit2の判定
        ok="end"   #bit2が1のときmesをendに設定
print()
print("スイープ終了")
print()


#測定値取得
inst_1.write("DATA:POIN? MEAS")   #スイープ測定データ点数の取得
mes=inst_1.read()   #スイープ測定データ点数の取得
inst_1.write(":DATA? MEAS,0," + str(int(mes)))   #測定データ点数分スイープ測定値を取得
mes=inst_1.read()   #測定データ点数分スイープ測定値を取得

y=mes.split(',')   #測定値をｙリストに入れる
n=len(y)   #yリストの長さを取得する。
i=0   #変数iの初期化
f=open("fra.dat","w")   #書き込み用ファイルfra.datをopenする。
print("frequency[Hz] , gain[dB] , phase[deg]")    #パネル表示のデータにヘッダを付ける。
f.write("frequency[Hz] , gain[dB] , phase[deg]"+'\n')   #fra.datにデータのヘッダを付ける。
while i<n:    #iがn以上になるまでループさせる
    data=y[i]+','+y[i+1]+','+y[i+2]   #yリストの要素を3つづつまとめて周波数、振幅、位相とする。
    print(data)   #つなぎ合わせたデータの表示
    f.write(data+'\n')   #つなぎ合わせたデータをfra.datへ書き込む
    i=i+3   #変数iを３インクリメントする。
f.close()   #fra.datを閉じる

print("終了")
