# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of 
# this software and associated documentation files (the "Software"), to deal in 
# the Software without restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
# the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


#　FRA51615のサンプルプログラム

# 2022.7.28
# 当プログラムはFRA51615の取扱説明書（外部制御）のp88のブロック図を基に作成した。
# スポットデータを測定する。

#　モジュールのインポート
import pyvisa  #pyvisaモジュールをインポート
from time import sleep #sleepをインポート

#FRAに接続
rm = pyvisa.ResourceManager()  #インスタンス生成
visa_list = rm.list_resources()    #PCに接続されている機器のVISAリソース名取得
usb_1 = visa_list[0]    #複数機器が接続されている場合[]内の数字で指定。
print(usb_1)
msg = rm.open_resource(usb_1)    #接続



#初期化設定
msg_er_lengs = 256     #msg.readstringの引数を決める。
msg.write ("*RST")        #FRAをリセットする。
msg.write ("*CLS")        #イベントレジスタを初期化。
msg.write (":STAT:OPER:NTR 4")      #スポット測定完了確認用に設定。
print()

#OSC設定
freq=input ('周波数を入力してください。 [Hz] ?')#周波数の入力
volt=input('振幅を入力してください。 [Vpk] ?')#振幅の入力
bias=input('オフセットを入力してください。 [V] ?')#DCバイアスの入力
func='SIN'#波形の指定
msg.write (":SOUR:FREQ " + freq) #スポット周波数を設定
msg.write (":SOUR:VOLT " + volt)    #内部発振器振幅を設定
msg.write (":SOUR:BIAS " + bias)    #DC バイアスを設定
msg.write (":SOUR:FUNC " + func)    #内部発振器波形を設定
msg.write (":OUTP ON")          #内部発振器出力をAC/DC ON 状態に設定
msg.write (":OUTP?")            #内部発振器出力状態を確認
mes = msg.read()                #内部発振器出力状態を読み取り
print()
    
#Mesure測定
integ=input('積分回数を入力してください。 ?')#積分回数を入力
msg.write (":SENS:AVER:COUN " +integ + ",CYCL") #積分回数を設定
    
#測定データフォーマット設定
msg.write (":CALC:FORM FREQ,MLOG,PHAS")    #測定結果を周波数，ゲイン，位相の形式で取得するよう設定

#測定開始
msg.write(":TRIG SPOT")   #スポット測定を開始

#スポット測定終了監視
while mes != "end":
    msg.write(":STAT:OPER?")   #測定が完了しているかオペレーションイベントレジスタで確認
    mes=msg.read()
    if int(mes) and 4 == 4 : #bit2の判定
        mes = "end" 
    else: 
        mes = ""  
    
#測定値取得
msg.write("DATA? SPOT")    #スポット測定データを取得
mes = msg.read()
print("frequncy [Hz] , gain[dB] , phase [deg] = ",mes)

print("終了")
