# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


# 作成　2022.9.8
# DM2571でAC電圧、直流電圧、周波数を測るプログラム。

from time import sleep  # sleepをimportする

import pyvisa  # pyvisaのインポート

rm = pyvisa.ResourceManager()  # インスタンスを生成

visa_list = rm.list_resources()  # PCに接続されている機器のVISAリソース名取得
usb_1 = visa_list[1]  # 複数機器が接続されている場合[]内の数字で指定。

print(usb_1)  # visaリソース名の表示

inst_2 = rm.open_resource(usb_1)  # 接続

inst_2.write("*RST")  # DM2571をリセットする。
sleep(1)
r_txt = inst_2.query("*IDN?")  # DM2571の機器確認をする。
print(r_txt)  # 返信を表示する。

print('\n')  # 改行
print('交流電圧[Vrms]')  # 交流電圧[Vrms]と表示
inst_2.write('conf:ac')  # 測定モードをAC電圧に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。
print('\n')  # 改行
print('直流電圧[V]')  # 直流電圧[V]と表示
inst_2.write('conf:dc')  # 測定モードをDC電圧に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。
print('\n')  # 改行
print('周波数[Hz]')  # 周波数[Hz]と表示
inst_2.write('conf:FREQ')  # 測定モードを周波数に設定
inst_2.write('samp:coun '+str(1))  # 測定回数を1回に指定
inst_2.write('val1?')  # DM2571の画面１のデータを読むように指示
out = inst_2.read()  # DM2571からデータを読み込む
print(out)  # 読み込んだデータを表示する。

print("終了")
