# Copyright (c) 2022 NF Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy of 
# this software and associated documentation files (the "Software"), to deal in 
# the Software without restriction, including without limitation the rights to use, 
# copy, modify, merge, publish, distribute, sublicense, and/or sell copies of 
# the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN 
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#2022.6.15
#CA5351をPyVISAで制御する。

import pyvisa as visa    #PyVISAをimportする。
from time import sleep    #sleepをimportする

rm=visa.ResourceManager()    #インスタンス生成
visa_list=rm.list_resources()    #PCに接続されている機器のVISAリソース名取得
print(visa_list)
usb_1=visa_list[0]    #複数機器が接続されている場合[]内の数字で指定。
inst_1=rm.open_resource(usb_1)    #接続

inst_1.write('*IDN?')    #接続の確認を行う。
sleep(0.1)    #PCからの返答待ち時間
out=inst_1.read()    #PCからの返答を読みこむ
print(out)    #PCからの返答をモニタに出力


dly=0.5 #待ち時間の指定[s]

inst_1.write("*RST") #*idn
sleep(dly) #状態が変わるのを待つ
print()
print("IVゲインの設定を行う。")
print(" gain   1k[V/A] => 1")
print(" gain  10k[V/A] => 2")
print(" gain 100k[V/A] => 3")
print(" gain   1M[V/A] => 4")
print(" gain  10M[V/A] => 5")
print(" gain 100M[V/A] => 6")
print(" gain   1G[V/A] => 7")
print(" gain  10G[V/A] => 8")
gain=input(" gain= ? ")     #IVゲインを設定する。
inst_1.write((":INPut:GAIN "+gain)) #IVゲインの設定
sleep(1)

print("CS設定を行う。レンジはオートにする。値は100μAにする。")
#CS設定範囲、-8mA〜+8mAの範囲で変更可能
CS="100e-6"    #CSの設定
inst_1.write((":INPut:BIAS:CURRent:RANGe:AUTO 1"))    #オートレンジに設定
inst_1.write((":INPut:BIAS:CURRent "+CS))    #CS値の設定
inst_1.write((":INPut:BIAS:CURRent:STATe ON"))    #CSを出力する。

print("フィルタの設定をOFFにする。")
FLT="OFF"
inst_1.write((":INPut:FILTer "+FLT))    #フィルタ状態を設定する。

print("ゼロチェックを無効にする")
inst_1.write((":INPut OFF"))    #ゼロチェックを無効にする


rm.close()
