Attribute VB_Name = "USB488ps"
' ------------------------------------------------------------------------
'
' Usb488ps.bas -- USB488 Protocol Stack API Declarations for Visual Basic
'
'       Copyright (C) 2003 NF Corporation
'
' This file contains only the Const, and Declare statements for USB488
' Protocol Stack APIs.
'
' You have a royalty-free right to use, modify, reproduce and distribute
' this file (and/or any modified version) in any way you find useful,
' provided that you agree that NF has no warranty, obligation or liability
' for its contents.
'
' ------------------------------------------------------------------------
Option Explicit

' UsbGetStatus return values
Public Const USB488_EERR = &H8000    ' Error detected
Public Const USB488_TIMO = &H4000   ' Timeout
Public Const USB488_SRQI = &H1000   ' SRQ detected by CIC

' UsbGetErrorCode return values
Public Const USB488_ENON = 0        ' Success
Public Const USB488_EDVR = 1        ' System error
Public Const USB488_ENOL = 3        ' Write function detected no listeners
Public Const USB488_EARG = 5        ' Invalid argument to function call
Public Const USB488_EABO = 7        ' I/O operation aborted
Public Const USB488_ETAB = 21       ' The return buffer is full
Public Const USB488_EINI = 128      ' UsbInitialize is not executed.
Public Const USB488_ECOM = 129      ' Commiunication error without timeout
Public Const USB488_ECOL = 130      ' Collision with USB488ID
Public Const USB488_EDAT = 131      ' Data commiunication error
Public Const USB488_ESND = 132      ' BULK OUT ERROR. Another function execute without to send NULL packet.
Public Const USB488_ERCV = 133      ' BULK IN ERROR. Another function execute without to receive NULL packet.
Public Const USB488_EOPN = 134      ' Device is not available without UsbOpenDevice( WORD ) function.
Public Const USB488_EHDL = 135      ' Invalid Usb488 Handle

' Class Request Type
Public Const SET_CLASS_REQ = &H20
Public Const GET_CLASS_REQ = &HA0

' Class Specific Request
Public Const SET_IFC = &H1
Public Const SET_SDC = &H2
Public Const SET_REN = &H3
Public Const GET_REN = &H4
Public Const SET_TRG = &H5
Public Const GET_TRG = &H6
Public Const SET_IOCTL = &H7
Public Const CLS_STB = &H8
Public Const SET_488ID = &H9
Public Const GET_488ID = &HA
Public Const GET_CAPA = &HB

' Message ID
Public Const MSG_CMD = 0    ' Common command
Public Const MSG_BIN = 1    ' Binary data

' Function ID
Public Const BIN_WITH_DC = &H1              ' Binary data with data counts.
Public Const BIN_WITHOUT_DC = &H2           ' Binary data without data counts.
Public Const BIN_WITHOUT_DC_WITH_HD = &H82  ' Binary data with ASCII header without data counts.

' Eom Mode
Public Const EOM_NULLPACKET = 1
Public Const EOM_CONTINUE = 0

' Binary Width
Public Const BINARY_BYTE = 1
Public Const BINARY_SHORT = 2
Public Const BINARY_LONG = 4
Public Const BINARY_SINGLE = 4
Public Const BINARY_DOUBLE = 8

' Capacity Bits of UsbGetCapacity
Public Const CAP_INTERRUPT_BIT = &H80			' Interupt transfer: 1=support
Public Const CAP_488_BIT = &H10					' 0:488.1, 1:488.2
Public Const CAP_ASCII_COMMON_CMD_BIT = &H08	' ASCII common command: 1=support
Public Const CAP_ENDIAN_BIT = &H01				' 0:big, 1:little

' Request Type
Public Const CONTROL_IN = &HA0
Public Const CONTROL_OUT = &H20

' UsbGetRemoteStatus return values
Public Const REM_STAT_LOCAL = &H00		' Local
Public Const REM_STAT_REMOTE = &H01		' Remote
Public Const REM_STAT_LOCKOUT = &H02	' Local Lockout

' UsbGetTriggerStatus return value
Public Const TRIGGER_BUSY = &H00		' Busy
Public Const TRIGGER_COMPLETE = &H01	' Complete

' Resource & Device management
Declare Sub UsbInitialize Lib "USB488ps.dll" ()
Declare Sub UsbFinalize Lib "USB488ps.dll" ()
Declare Function UsbGetDeviceList Lib "USB488ps.dll" (ByVal dwNth As Long, ByRef Buffer As Integer, _
        ByVal dwSize As Long) As Long
Declare Function UsbOpenDevice Lib "USB488ps.dll" (ByVal i488Id As Integer) As Long
Declare Sub UsbCloseDevice Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Function UsbGetStatus Lib "USB488ps.dll" () As Integer
Declare Function UsbGetErrorCode Lib "USB488ps.dll" () As Integer
Declare Function UsbGetDataCount Lib "USB488ps.dll" () As Long
Declare Sub UsbSetTimeout Lib "USB488ps.dll" (ByVal hDev As Long, ByVal iTimeout As Long)
Declare Function UsbGetTimeout Lib "USB488ps.dll" (ByVal hDev As Long) As Long
        
' Class Specific Requests
Declare Function UsbControlOUT Lib "USB488ps.dll" (ByVal hDev As Long, ByVal ReqquestType As Byte, _
        ByVal bRequest As Byte, ByVal wValue As Long, ByVal wIndex As Integer, ByVal wLength As Integer, _
        ByVal pDataStage As Any) As Long
Declare Function UsbControlIN Lib "USB488ps.dll" (ByVal hDev As Long, ByVal bmRequestType As Byte, _
        ByVal bRequest As Byte, ByVal wValue As Integer, ByVal wIndex As Integer, ByVal wLength As Integer, _
        ByRef pDataStage As Any) As Long
Declare Sub UsbSetIFC Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbDevClear Lib "USB488ps.dll" (ByVal hDev As Long, ByVal wValue As Integer)
Declare Sub UsbEnableRemote Lib "USB488ps.dll" (ByRef pDevList As Long)
Declare Sub UsbEnableLocal Lib "USB488ps.dll" (ByRef pDevList As Long)
Declare Sub UsbSendLLO Lib "USB488ps.dll" (ByRef pDevList As Long)
Declare Sub UsbGetRemoteStatus Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pStatus As Byte)
Declare Sub UsbTrigger Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbGetTriggerStatus Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pStatus As Byte)
Declare Sub UsbSendIOCTL Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pDataStage As Any, ByVal wLength As Integer)
Declare Sub UsbClearStatusByte Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbSet488ID Lib "USB488ps.dll" (ByVal hDev As Long, ByVal i488Id As Integer)
Declare Sub UsbGet488ID Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pi488Id As Integer)
Declare Sub UsbGetCapacity Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pCapacity As Any, ByVal wLength As Integer)

' Bulk In & Out
Declare Sub UsbSend Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pBuf As Any, ByVal dwCount As Long, _
        ByVal dwMode As Long)
Declare Sub UsbReceive Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pBuf As Any, ByVal dwCount As Long, _
        ByRef pdwMode As Long)
Declare Sub UsbCLS Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbSESE Lib "USB488ps.dll" (ByVal hDev As Long, ByVal dwSESE As Long)
Declare Sub UsbSESEQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long)
Declare Sub UsbSESRQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long)
Declare Sub UsbIDNQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByVal pResult As String, ByVal iBufSize As Long)
Declare Sub UsbOPC Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbOPCQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long, ByVal dwTimeout As Long)
Declare Sub UsbReset Lib "USB488ps.dll" (ByVal hDev As Long)
Declare Sub UsbSRE Lib "USB488ps.dll" (ByVal hDev As Long, ByVal dwData As Long)
Declare Sub UsbSREQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long)
Declare Sub UsbSTBQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long)
Declare Sub UsbSelfTestQuery Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pResult As Long)
Declare Sub UsbWait Lib "USB488ps.dll" (ByVal hDev As Long)

' Formatted BINARY & TEXT Bulk In/Out
Declare Sub UsbSendBinaryWithCnt Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pBuffer As Any, _
        ByVal dwCount As Long, ByVal iWidth As Long)
Declare Sub UsbSendBinary Lib "USB488ps.dll" (ByVal hDev As Long, ByRef pBuffer As Any, ByVal dwCount As Long, _
        ByVal iWidth As Long)
Declare Sub UsbSendBinaryWithHeader Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpszHeader As String, _
        ByRef pBuffer As Any, ByVal dwCount As Long, ByVal iWidth As Long)
Declare Sub UsbSendBinaryData Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpszHeader As String, _
        ByRef pBuffer As Any, ByVal dwCount As Long, ByVal iWidth As Long, ByVal iFuncID As Long)
Declare Sub UsbSendTextData Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpszHeader As String)
Declare Function UsbReceiveBinaryData Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpszHeader As String, _
        ByRef pBuffer As Any, ByVal dwCount As Long, ByRef pWidth As Long, ByRef pFuncID As Long) As Long
Declare Function UsbReceiveTextData Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpszText As String, _
        ByVal dwCount As Long) As Long
Declare Sub UsbSetSrqRoutine Lib "USB488ps.dll" (ByVal hDev As Long, ByVal lpfnSrqRoutine As Long, _
        ByVal lParam As Long)
